%Set up timer rpt freq will be 40e6/(65536*8)=76.294Hz
udpset(skt,'T3CON',bin2dec('1000 0000 0001 0000'));
udpset(skt,'PR3',65535);

%Set up OC1
udpset(skt,'OC1RS',5000);
udpset(skt,'OC1CON',bin2dec('0000 0000 0000 1110'));

%Set up OC2
udpset(skt,'OC2RS',5000);
udpset(skt,'OC2CON',bin2dec('0000 0000 0000 1110'));

%Attach to pins RP14 and RP15
udpset(skt,'RPOR7',bin2dec('0001 0010 0001 0011'));

%Full Scales for servos
smax=12000;
smin=3000;

%Initialise Phase accumulators
p1=0.0;
p2=0.0;
t=0;

%loop timing
srate=20; %in Hz
period=1/srate;
tic;

%frequency of servo oscillations
f1=0.25; %in Hz
f2=0.1; %in Hz

%do until kbhit
while (size(kbhit(1))(1)<1)
    
%Send sine to OC1  

 p1=p1+f1*360/srate;   
 if (p1>360) p1=p1-360; end
 s1=uint16((sin(p1*pi/180)*(smax-smin)/2)+mean([smax smin]));
 udpset(skt,'OC1RS',s1);

 %Send sine to OC2  
 p2=p2+f2*360/srate;   
 if (p2>360) p2=p2-360; end
 s2=uint16((sin(p2*pi/180)*(smax-smin)/2)+mean([smax smin]));
 udpset(skt,'OC2RS',s2);
 
 t=t+period;
 while(toc<t); end;
end  
